/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.slf4j.Logger;
import space.essem.image2map.config.Image2MapConfig;
import space.essem.image2map.gui.PreviewGui;
import space.essem.image2map.renderer.MapRenderer;

public class Image2Map
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Image2MapConfig CONFIG = Image2MapConfig.loadOrCreateConfig();

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"image2map").requires(source -> source.method_9259(Image2Map.CONFIG.minPermLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider()).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMap)))))).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider()).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMap))))).then(class_2170.method_9247((String)"preview").then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::openPreview)))));
    }

    private int openPreview(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String input = StringArgumentType.getString(context, (String)"path");
        source.method_9226((class_2561)class_2561.method_43470((String)"Getting image..."), false);
        this.getImage(input).orTimeout(60L, TimeUnit.SECONDS).handleAsync((image, ex) -> {
            GuiInterface patt4308$temp;
            if (image == null || ex != null) {
                source.method_9226((class_2561)class_2561.method_43470((String)"That doesn't seem to be a valid image!"), false);
            }
            if ((patt4308$temp = GuiHelpers.getCurrentGui((class_3222)source.method_44023())) instanceof PreviewGui) {
                PreviewGui previewGui = (PreviewGui)patt4308$temp;
                previewGui.close();
            }
            new PreviewGui(((class_2168)context.getSource()).method_44023(), (BufferedImage)image, input, DitherMode.NONE, image.getWidth(), image.getHeight());
            return null;
        }, (Executor)source.method_9211());
        return 1;
    }

    private CompletableFuture<BufferedImage> getImage(String input) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (Image2Map.isValid(input)) {
                    URL url = new URL(input);
                    URLConnection connection = url.openConnection();
                    connection.setRequestProperty("User-Agent", "Image2Map mod");
                    connection.connect();
                    return ImageIO.read(connection.getInputStream());
                }
                if (Image2Map.CONFIG.allowLocalFiles) {
                    File file = new File(input);
                    return ImageIO.read(file);
                }
                return null;
            }
            catch (Throwable e) {
                return null;
            }
        });
    }

    private int createMap(CommandContext<class_2168> context) throws CommandSyntaxException {
        DitherMode mode;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String modeStr = StringArgumentType.getString(context, (String)"mode");
        try {
            mode = DitherMode.fromString(modeStr);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType(() -> "Invalid dither mode '" + modeStr + "'").create();
        }
        String input = StringArgumentType.getString(context, (String)"path");
        source.method_9226((class_2561)class_2561.method_43470((String)"Getting image..."), false);
        this.getImage(input).orTimeout(60L, TimeUnit.SECONDS).handleAsync((arg_0, arg_1) -> Image2Map.lambda$createMap$7(source, context, mode, input, (class_1657)player, arg_0, arg_1), (Executor)source.method_9211());
        return 1;
    }

    public static void giveToPlayer(class_1657 player, List<class_1799> items, String input, int width, int height) {
        if (items.size() == 1) {
            player.method_7270(items.get(0));
        } else {
            class_1799 bundle = new class_1799((class_1935)class_1802.field_27023);
            class_2499 list = new class_2499();
            for (class_1799 item : items) {
                list.add((Object)item.method_7953(new class_2487()));
            }
            bundle.method_7948().method_10566("Items", (class_2520)list);
            bundle.method_7948().method_10556("image2map:quick_place", true);
            bundle.method_7948().method_10569("image2map:width", class_3532.method_15384((double)((double)width / 128.0)));
            bundle.method_7948().method_10569("image2map:height", class_3532.method_15384((double)((double)height / 128.0)));
            class_2499 lore = new class_2499();
            lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)input))));
            bundle.method_7911("display").method_10566("Lore", (class_2520)lore);
            bundle.method_7977((class_2561)class_2561.method_43470((String)"Maps").method_27692(class_124.field_1065));
            player.method_7270(bundle);
        }
    }

    public static boolean clickItemFrame(class_1657 player, class_1268 hand, class_1533 itemFrameEntity) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7985() && stack.method_31574(class_1802.field_27023) && stack.method_7969().method_10577("image2map:quick_place")) {
            int rot;
            class_2350 down;
            class_2350 right;
            class_1937 world = itemFrameEntity.field_6002;
            class_2338 start = itemFrameEntity.method_24515();
            int width = stack.method_7969().method_10550("image2map:width");
            int height = stack.method_7969().method_10550("image2map:height");
            class_1533[] frames = new class_1533[width * height];
            class_2350 facing = itemFrameEntity.method_5735();
            if (facing.method_10166() != class_2350.class_2351.field_11052) {
                right = facing.method_10160();
                down = class_2350.field_11033;
                rot = 0;
            } else {
                right = player.method_5735().method_10170();
                if (facing.method_10171() == class_2350.class_2352.field_11056) {
                    down = right.method_10170();
                    rot = player.method_5735().method_10153().method_10161();
                } else {
                    down = right.method_10160();
                    rot = (right.method_10166() == class_2350.class_2351.field_11051 ? player.method_5735() : player.method_5735().method_10153()).method_10161();
                }
            }
            class_2338.class_2339 mut = start.method_25503();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    mut.method_10101((class_2382)start);
                    mut.method_10104(right, x);
                    mut.method_10104(down, y);
                    List entities = world.method_8390(class_1533.class, class_238.method_29968((class_243)class_243.method_24954((class_2382)mut)), entity1 -> entity1.method_5735() == facing && entity1.method_24515().equals((Object)mut));
                    if (entities.isEmpty()) continue;
                    frames[x + y * width] = (class_1533)entities.get(0);
                }
            }
            for (class_2520 nbt : stack.method_7969().method_10554("Items", 10)) {
                int y;
                int x;
                class_1533 frame;
                class_1799 map = class_1799.method_7915((class_2487)((class_2487)nbt));
                if (!map.method_7985() || (frame = frames[(x = map.method_7969().method_10550("image2map:x")) + (y = map.method_7969().method_10550("image2map:y")) * width]) == null || !frame.method_6940().method_7960()) continue;
                frame.method_6935(map);
                frame.method_6939(rot);
            }
            return true;
        }
        return false;
    }

    private static boolean isValid(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ Object lambda$createMap$7(class_2168 source, CommandContext context, DitherMode mode, String input, class_1657 player, BufferedImage image, Throwable ex) {
        int height;
        int width;
        if (image == null || ex != null) {
            source.method_9226((class_2561)class_2561.method_43470((String)"That doesn't seem to be a valid image!"), false);
        }
        try {
            width = IntegerArgumentType.getInteger((CommandContext)context, (String)"width");
            height = IntegerArgumentType.getInteger((CommandContext)context, (String)"height");
        }
        catch (Throwable e) {
            width = image.getWidth();
            height = image.getHeight();
        }
        int finalHeight = height;
        int finalWidth = width;
        source.method_9226((class_2561)class_2561.method_43470((String)"Converting into maps..."), false);
        CompletableFuture.supplyAsync(() -> MapRenderer.render(image, mode, finalWidth, finalHeight)).thenAcceptAsync(mapImage -> {
            List<class_1799> items = MapRenderer.toVanillaItems(mapImage, source.method_9225(), input);
            Image2Map.giveToPlayer(player, items, input, finalWidth, finalHeight);
            source.method_9226((class_2561)class_2561.method_43470((String)"Done!"), false);
        }, (Executor)source.method_9211());
        return null;
    }

    public static enum DitherMode {
        NONE,
        FLOYD;


        public static DitherMode fromString(String string) {
            if (string.equalsIgnoreCase("NONE")) {
                return NONE;
            }
            if (string.equalsIgnoreCase("DITHER") || string.equalsIgnoreCase("FLOYD")) {
                return FLOYD;
            }
            throw new IllegalArgumentException("invalid dither mode");
        }
    }

    class DitherModeSuggestionProvider
    implements SuggestionProvider<class_2168> {
        DitherModeSuggestionProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            builder.suggest("none");
            builder.suggest("dither");
            return builder.buildFuture();
        }
    }
}

